package com.ejie.aa17a.dao.iface;

import java.math.BigDecimal;
import java.util.List;

import com.ejie.aa17a.model.Aa17aDatoHistorico;

/**
 * Aa17aDatoHistoricoDao generated by UDA, 18-dic-2013 15:36:13.
 * 
 * @author UDA
 */

public interface Aa17aDatoHistoricoDao {

	/**
	 * Devuelve los datos historicos para cargar el grafico
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico
	 * @return List
	 */
	List<BigDecimal[]> getDatosHistorico(Aa17aDatoHistorico aa17adatohistorico);

	/**
	 * Devuelve el máximo idBanda del dia anterior al actual de los datos
	 * historicos de una estacion
	 * 
	 * @param idEstacion
	 *            Long
	 * @return Long
	 */
	Long getMaxIdBandaEstacion(Long idEstacion);

	/**
	 * Devuelve el idBanda del dia anterior al actual de los datos historicos de
	 * una estacion y un contaminante
	 * 
	 * @param datoHistorico
	 *            Aa17aDatoHistorico
	 * @return Long
	 */
	Long getIdBandaContaminante(Aa17aDatoHistorico datoHistorico);

	/**
	 * Devuelve los datos historicos en una lista de beans
	 * 
	 * @param aa17adatohistorico
	 *            Aa17aDatoHistorico
	 * @return List<Aa17aDatoHistorico>
	 */
	List<Aa17aDatoHistorico> listDatosHistoricos(Aa17aDatoHistorico aa17adatohistorico);

}
